<?php
/**
 * Generate Webhook Signing Secret Controller
 *
 * @category  ChatData
 * @package   ChatData_ProductWebhook
 * @author    Chat Data LLC
 * @copyright Copyright (c) 2025 Chat Data LLC
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

declare(strict_types=1);

namespace ChatData\ProductWebhook\Controller\Adminhtml\Webhook;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Math\Random;

class GenerateSecret extends Action
{
    /**
     * ACL resource
     */
    public const ADMIN_RESOURCE = 'ChatData_ProductWebhook::webhook_generate_secret';

    /**
     * Constructor
     */
    public function __construct(
        Context $context,
        private readonly JsonFactory $resultJsonFactory,
        private readonly Random $mathRandom
    ) {
        parent::__construct($context);
    }

    /**
     * Execute action
     *
     * Generates a cryptographically secure random secret
     */
    public function execute()
    {
        $result = $this->resultJsonFactory->create();

        try {
            // Generate 32-character alphanumeric string
            // This is simpler and less prone to issues than long hex strings
            $secret = $this->mathRandom->getRandomString(32);

            return $result->setData([
                'success' => true,
                'secret' => $secret,
                'message' => __('Secret generated successfully.')
            ]);

        } catch (\Exception $e) {
            return $result->setData([
                'success' => false,
                'message' => __('An error occurred while generating the secret: %1', $e->getMessage())
            ]);
        }
    }
}
