# Chat Data Product Webhook for Magento 2

[![License](https://img.shields.io/badge/license-OSL--3.0-blue.svg)](LICENSE.txt)
[![Magento](https://img.shields.io/badge/magento-2.4.x-orange.svg)](https://magento.com)
[![PHP](https://img.shields.io/badge/php-8.1%2B-blue.svg)](https://www.php.net/)

## Overview

The **Chat Data Product Webhook** extension seamlessly integrates your Magento 2 store with the Chat Data AI chatbot platform. It automatically sends real-time product events (create, update, delete) to Chat Data, ensuring your chatbot always has the latest product information to provide accurate responses to customers.

## Features

- **Real-time Product Sync**: Automatically sends product create, update, and delete events to Chat Data
- **Comprehensive Data Capture**: Includes product details, categories, attributes, inventory, pricing, and media
- **Inventory Tracking**: Monitors stock changes and triggers product updates
- **Category Management**: Tracks category changes affecting products
- **Simple Configuration**: Just enter your webhook URL to get started
- **Secure Webhooks**: HMAC-SHA256 signature validation for webhook security
- **Immediate Delivery**: Webhooks are sent right away (no queue)
- **Transient Retry**: Automatically retries failed deliveries a few times
- **Test Connection**: Verify configuration with a test webhook

## Requirements

- Magento Open Source or Adobe Commerce 2.4.x
- PHP 8.1, 8.2, or 8.3
- Chat Data account and chatbot ([sign up here](https://www.chat-data.com))

## Installation

### Option 1: Composer (Recommended)

```bash
# Add Chat Data repository (when published)
composer require chatdata/module-product-webhook

# Enable the module
php bin/magento module:enable ChatData_ProductWebhook

# Run setup upgrade
php bin/magento setup:upgrade

# Compile DI
php bin/magento setup:di:compile

# Deploy static content (production mode)
php bin/magento setup:static-content:deploy

# Clear cache
php bin/magento cache:flush
```

### Option 2: Manual Installation

1. Download and extract the module files
2. Copy the `ChatData` folder to `app/code/` in your Magento installation
3. Run the following commands:

```bash
php bin/magento module:enable ChatData_ProductWebhook
php bin/magento setup:upgrade
php bin/magento setup:di:compile
php bin/magento setup:static-content:deploy
php bin/magento cache:flush
```

## Configuration

1. **Log in to Magento Admin Panel**

2. **Navigate to Configuration**
   - Go to: `Stores > Configuration > Chat Data > Product Webhook`

3. **General Settings**
   - **Enable Webhook**: Set to "Yes" to activate the module
   - **Webhook URL**: Enter the full webhook URL from your Chat Data integration settings (includes your chatbot ID)
   - **Webhook Signing Secret**: Auto-generated by the extension and required for non-test events; copy it into your Chat Data integration settings
   - **Test Connection**: Click to send a test webhook and verify configuration

4. **Save Configuration**
    - Click "Save Config" and clear the cache

## How It Works

### Event Flow

1. **Product Event Occurs** (create, update, delete, inventory change, category change)
2. **Observer Triggers** → Module detects the event
3. **Payload Built** → Complete product data assembled
4. **Send Immediately** → HTTP POST to Chat Data webhook URL
5. **Chat Data Receives** → Webhook endpoint processes the event
6. **Chatbot Updated** → Product information refreshed in Chat Data

### Webhook Payload Format

For create/update events:
```json
{
  "event_type": "product.created|product.updated",
  "timestamp": "2025-12-31T14:30:00Z",
  "store_code": "default",
  "product": {
    "id": 123,
    "sku": "ABC-001",
    "name": "Product Name",
    "price": 99.99,
    "custom_attributes": [...],
    "extension_attributes": {...}
  },
  "store_info": {...}
}
```

For delete events:
```json
{
  "event_type": "product.deleted",
  "timestamp": "2025-12-31T14:30:00Z",
  "store_code": "default",
  "product": {
    "id": 123,
    "sku": "ABC-001"
  }
}
```

### Queue System

Queue processing is disabled in this build. Webhooks are sent immediately to the configured URL.

## Events Monitored

The module monitors the following Magento events:

| Magento Event | Webhook Event Type | Description |
|---------------|-------------------|-------------|
| `catalog_product_save_after` | `product.created` or `product.updated` | New product or product modification |
| `catalog_product_delete_after_done` | `product.deleted` | Product deletion |
| `cataloginventory_stock_item_save_after` | `product.updated` | Inventory/stock changes |
| `catalog_category_save_after` | `product.updated` | Category name changes (updates product categories) |
| `catalog_category_delete_before` | `product.updated` | Category deletion (affects product category_ids) |

## Troubleshooting

### Test Webhook Not Received

1. Verify the **Webhook URL** is the correct one for your Chat Data chatbot
2. Check that the **Signing Secret** shown in Magento matches your Chat Data integration settings
3. Ensure your server can make outbound HTTPS requests
4. Review `var/log/chatdata_webhook.log` for webhook errors
5. Check firewall rules allowing outbound traffic to `api.chat-data.com`

### Products Not Syncing

1. Verify the module is **Enabled** in configuration
2. Confirm the product is enabled and visible
3. Ensure the webhook URL and signing secret are configured (the signing secret is auto-generated and required for non-test events)
4. Review `var/log/system.log` and `var/log/chatdata_webhook.log`

### HMAC Signature Validation Errors

1. Verify the **Signing Secret** exactly matches Chat Data integration settings
2. Check for whitespace in the signing secret configuration field

## Support

- **Documentation**: [https://www.chat-data.com/docs](https://www.chat-data.com/docs)
- **Support Email**: support@chat-data.com
- **Chat Data Dashboard**: [https://www.chat-data.com](https://www.chat-data.com)

## License

This extension is licensed under the [Open Software License (OSL 3.0)](LICENSE.txt).

## Changelog

### Version 1.0.0
- Initial release
- Real-time product event synchronization
- Immediate webhook delivery (no queue)
- HMAC-SHA256 signature validation
- Comprehensive admin configuration
- Support for Magento 2.4.x

---

**Developed by Chat Data LLC**
© 2025 Chat Data LLC. All rights reserved.
