# Magento 2 Product Webhook Module - Testing Guide

## Installation Status ✅

The module has been successfully installed in your test Magento store:

- **Module Location**: `/home/yongrui/Documents/magento_store/m2/src/app/code/ChatData/ProductWebhook/`
- **Status**: ✅ Enabled
- **Compilation**: ✅ Passed
- **Cache**: ✅ Cleared

## Next Steps for Testing

### 1. Access Magento Admin Panel

Your Magento store is running at:
- **Frontend**: http://localhost (port 80)
- **Admin**: http://localhost/admin

To get admin credentials, check your environment or create a new admin user:
```bash
cd /home/yongrui/Documents/magento_store/m2
bin/cli bin/magento admin:user:create
```

### 2. Configure the Module

Navigate to: **Stores > Configuration > Chat Data > Product Webhook**

#### Required Configuration:

**General Settings:**
- **Enable Webhook**: Yes
- **Webhook URL**: (your full Chat Data webhook URL, includes your chatbot ID)
- **Webhook Signing Secret**: (from Chat Data integration settings)

### 3. Test Connection

1. In the admin configuration, scroll to **General Settings**
2. Click the **Test Connection** button
3. Check the response - should show success message
4. Verify the test webhook was received in Chat Data logs

### 4. Test Product Create Event

#### Test 1: Create a Simple Product

```bash
cd /home/yongrui/Documents/magento_store/m2

# Option A: Via CLI (faster for testing)
bin/cli bin/magento catalog:product:create \
  --sku="TEST-PRODUCT-001" \
  --name="Test Product for Webhook" \
  --price=99.99 \
  --qty=100 \
  --visibility=4 \
  --status=1
```

#### Test 2: Create via Admin UI

1. Go to **Catalog > Products**
2. Click **Add Product**
3. Fill in:
   - **Product Name**: Test Webhook Product
   - **SKU**: TEST-WEBHOOK-001
   - **Price**: $49.99
   - **Quantity**: 50
   - **Stock Status**: In Stock
4. Click **Save**

**Expected Result:**
- Webhook sent to Chat Data with `event_type: "product.created"`
- Check log file for errors: `/home/yongrui/Documents/magento_store/m2/src/var/log/chatdata_webhook.log`
- Verify product appears in Chat Data chatbot knowledge base

### 5. Test Product Update Event

#### Update Product Price

```bash
cd /home/yongrui/Documents/magento_store/m2

# Update product via CLI
bin/cli bin/magento catalog:product:attribute:update \
  --sku="TEST-PRODUCT-001" \
  --price=79.99
```

Or via Admin:
1. Go to **Catalog > Products**
2. Edit the test product
3. Change the **Price** from $99.99 to $79.99
4. Click **Save**

**Expected Result:**
- Webhook sent with `event_type: "product.updated"`
- Updated price reflected in Chat Data

### 6. Test Inventory Change Event

```bash
cd /home/yongrui/Documents/magento_store/m2

# Update stock quantity
bin/cli bin/magento catalog:product:attribute:update \
  --sku="TEST-PRODUCT-001" \
  --qty=50
```

Or via Admin:
1. Edit product
2. Change **Quantity** from 100 to 50
3. Click **Save**

**Expected Result:**
- Webhook sent with `event_type: "product.updated"`
- `extension_attributes.stock_item.qty` should be 50

### 7. Test Product Delete Event

```bash
cd /home/yongrui/Documents/magento_store/m2

# Delete product via CLI
bin/cli bin/magento catalog:product:delete --sku="TEST-PRODUCT-001"
```

Or via Admin:
1. Go to **Catalog > Products**
2. Select the test product
3. Click **Delete**
4. Confirm deletion

**Expected Result:**
- Webhook sent with `event_type: "product.deleted"`
- Minimal payload with only `id` and `sku`
- Product removed from Chat Data

### 8. Test Category Change Event

1. Go to **Catalog > Categories**
2. Select a category (e.g., "Men")
3. Change the category name to "Men's Clothing"
4. Click **Save Category**

**Expected Result:**
- Webhook sent for ALL products in that category with `event_type: "product.updated"`
- Products' `category_map` updated with new category name

### 9. Check Logs

#### Webhook Log

```bash
cd /home/yongrui/Documents/magento_store/m2

# Watch the webhook log in real-time
tail -f src/var/log/chatdata_webhook.log

# Or view recent entries
tail -100 src/var/log/chatdata_webhook.log
```

**What to Look For:**
- Webhook send failures
- Observer errors during product/category/stock updates

#### System Log

```bash
tail -100 src/var/log/system.log | grep ChatData
```

#### Exception Log (if errors occur)

```bash
tail -100 src/var/log/exception.log
```

### 10. Verify Webhook Payload

If you need to inspect payloads, temporarily point the webhook URL to a request inspector or review the payloads in Chat Data logs.

**Verify Payload Structure:**
```json
{
  "event_type": "product.created",
  "timestamp": "2025-12-31T...",
  "store_code": "default",
  "product": {
    "id": 123,
    "sku": "TEST-001",
    "name": "Test Product",
    "price": 99.99,
    "custom_attributes": [...],
    "extension_attributes": {
      "stock_item": {
        "qty": 100,
        "is_in_stock": true
      }
    }
  },
  "category_map": {...},
  "attribute_options_map": {...},
  "attribute_set_map": {...},
  "store_info": {
    "base_url": "http://localhost/",
    "currency_code": "USD",
    "magento_domain": "http://localhost/rest"
  }
}
```

### 11. Common Issues & Solutions

#### Issue: Webhooks Not Sending

**Check:**
```bash
cd /home/yongrui/Documents/magento_store/m2

# Verify module is enabled
bin/cli bin/magento module:status ChatData_ProductWebhook

# Check if observers are registered
bin/cli bin/magento events:list | grep chatdata

# Verify configuration
bin/mysql -e "SELECT * FROM core_config_data WHERE path LIKE 'chatdata_webhook%';"
```

#### Issue: HMAC Signature Mismatch

- Ensure **Webhook Signing Secret** in Magento matches Chat Data integration
- Check for whitespace in the secret field

### 12. Performance Testing

#### Test High Volume

```bash
cd /home/yongrui/Documents/magento_store/m2

# Create multiple products quickly
for i in {1..10}; do
  bin/cli bin/magento catalog:product:create \
    --sku="BULK-TEST-$i" \
    --name="Bulk Test Product $i" \
    --price=$((RANDOM % 100 + 10))
done
```

**Monitor:**
- Response time in logs
- Memory usage
- Error rate

### 13. Clean Up Test Data

```bash
cd /home/yongrui/Documents/magento_store/m2

# Delete test products
bin/cli bin/magento catalog:product:delete --sku="TEST-PRODUCT-001"
bin/cli bin/magento catalog:product:delete --sku="TEST-WEBHOOK-001"

# Clear logs
> src/var/log/chatdata_webhook.log
```

## Expected Test Results Summary

✅ **Module Installation**: Enabled, compiled, cache cleared
✅ **Configuration**: Accessible in admin panel
✅ **Test Connection**: Successfully sends test webhook
✅ **Product Create**: Webhook sent with full product data
✅ **Product Update**: Webhook sent with updated data
✅ **Inventory Change**: Triggers product.updated event
✅ **Category Change**: Updates all affected products
✅ **Product Delete**: Sends minimal deletion payload
✅ **Logging**: Errors written to chatdata_webhook.log

## Ready for Production?

Once all tests pass:

1. ✅ Monitor logs regularly
2. ✅ Test with real Chat Data chatbot

## Support

If you encounter issues during testing:
- Check `/home/yongrui/Documents/magento_store/m2/src/var/log/chatdata_webhook.log`
- Review Chat Data server logs for webhook receipt
- Verify network connectivity to `api.chat-data.com`
- Ensure all required configuration fields are filled

---

**Module successfully installed and ready for testing!** 🚀
