# Chat Data Webhook Plugin for Shopware 6

This plugin automatically sends product webhook events to Chat Data when products are created, updated, or deleted in your Shopware 6 store.

## Requirements

- Shopware 6.5.x or 6.6.x
- PHP 8.1 or higher

## Installation

### Via Composer (Recommended)

```bash
composer require chat-data/shopware-webhook
bin/console plugin:refresh
bin/console plugin:install --activate ChatDataWebhook
bin/console cache:clear
```

### Manual Installation

1. Download the plugin ZIP file
2. Extract to `custom/plugins/ChatDataWebhook`
3. Run the following commands:

```bash
bin/console plugin:refresh
bin/console plugin:install --activate ChatDataWebhook
bin/console cache:clear
```

## Configuration

1. Go to **Settings** > **System** > **Plugins** in Shopware Admin
2. Find "Chat Data Webhook" and click on the **...** menu
3. Select **Configuration**
4. Configure the following settings:

| Setting | Description |
|---------|-------------|
| **Webhook URL** | Your Chat Data webhook endpoint URL (get this from Chat Data integration settings) |
| **Webhook Signing Secret** | Secret key for HMAC signature verification (optional but recommended) |
| **Store Domain** | Your Shopware storefront domain (used in webhook payloads) |

## Getting Your Webhook URL

1. Log in to your [Chat Data](https://www.chat-data.com) account
2. Go to your chatbot settings
3. Navigate to the **Integrations** section
4. Select **Shopware** integration
5. Copy the webhook URL provided

## Webhook Events

The plugin sends the following webhook events:

| Event | Description |
|-------|-------------|
| `product.created` | Sent when a new product is created |
| `product.updated` | Sent when an existing product is updated |
| `product.deleted` | Sent when a product is deleted |

## Webhook Headers

Each webhook request includes the following headers:

```
Content-Type: application/json
x-shopware-webhook-topic: product.created | product.updated | product.deleted
x-shopware-webhook-signature: <HMAC-SHA256 signature in base64>
```

## Webhook Payload

### For Create/Update Events

```json
{
  "id": "product-uuid",
  "active": true,
  "name": "Product Name",
  "description": "Product description",
  "ean": "1234567890123",
  "manufacturerNumber": "SKU-123",
  "productNumber": "SW-12345",
  "stock": 100,
  "availableStock": 95,
  "price": [...],
  "translated": {
    "name": "Translated Name",
    "description": "Translated Description"
  },
  "manufacturer": {...},
  "categories": [...],
  "media": [...],
  "seoUrls": [...],
  "tax": {...},
  "properties": [...],
  "options": [...],
  ...
}
```

### For Delete Events

```json
{
  "id": "product-uuid"
}
```

## Troubleshooting

### Webhooks not being sent

1. Check that the plugin is enabled in plugin settings
2. Verify the webhook URL is correct
3. Check Shopware logs for any errors: `var/log/`

### Signature verification failing

1. Ensure the signing secret matches what's configured in Chat Data
2. Check that the secret doesn't have any extra whitespace

## Support

For support, please visit [Chat Data Help](https://www.chat-data.com/help) or contact support@chat-data.com.

## License

MIT License - see LICENSE file for details.
