<?php declare(strict_types=1);

namespace ChatData\Webhook;

use Shopware\Core\Framework\Plugin;
use Shopware\Core\Framework\Plugin\Context\ActivateContext;
use Shopware\Core\Framework\Plugin\Context\InstallContext;
use Shopware\Core\Framework\Plugin\Context\UninstallContext;
use Shopware\Core\System\SystemConfig\SystemConfigService;

class ChatDataWebhook extends Plugin
{
    public function install(InstallContext $installContext): void
    {
        parent::install($installContext);

        $this->ensureSigningSecret();
    }

    public function activate(ActivateContext $activateContext): void
    {
        parent::activate($activateContext);

        $this->ensureSigningSecret();
    }

    private function ensureSigningSecret(): void
    {
        /** @var SystemConfigService $systemConfigService */
        $systemConfigService = $this->container->get(SystemConfigService::class);

        // Check if secret exists, if not generate one
        if (!$systemConfigService->get('ChatDataWebhook.config.signingSecret')) {
            $randomSecret = bin2hex(random_bytes(32));
            $systemConfigService->set('ChatDataWebhook.config.signingSecret', $randomSecret);
        }
    }

    public function uninstall(UninstallContext $uninstallContext): void
    {
        parent::uninstall($uninstallContext);

        if ($uninstallContext->keepUserData()) {
            return;
        }

        // Clean up system config entries if needed
    }
}
